DROP PROCEDURE [hips].[ConsentAuditInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 14 November 2012
-- Description:   Inserts a new record into the Consent Audit Table
-- Modified: 18/12/2012 Simon added AuditInformation parameter
-- =============================================
CREATE PROCEDURE [hips].[ConsentAuditInsert] 
(
	  @EpisodeId INT
	, @ConsentWithdrawn BIT
	, @AuditInformation VARBINARY(MAX) = NULL
	, @UserModified varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @ConsentAuditId int

    SET @intErrorCode = 0


	INSERT INTO hips.ConsentAudit
	(
		[EpisodeId],
		[ConsentWithdrawn],
		[AuditInformation],
		[DateCreated],
        [UserCreated],
        [DateModified],
        [UserModified]
		)
VALUES
	(
	  @EpisodeId
	, @ConsentWithdrawn
	, @AuditInformation
	, GETDATE()
    , @UserModified
    , GETDATE()
    , @UserModified
	)
	
	 SELECT @intErrorCode = @@ERROR , @ConsentAuditId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [ConsentAuditId],
                EpisodeId,
                ConsentWithdrawn,
				AuditInformation,
                [DateCreated],
                [UserCreated],
                [DateModified],
                [UserModified]
         FROM [hips].[ConsentAudit]
         WHERE [ConsentAuditId] = @ConsentAuditId
    END

    RETURN(@intErrorCode)

END

GO

